(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     14395,        309]*)
(*NotebookOutlinePosition[     15095,        333]*)
(*  CellTagsIndexPosition[     15051,        329]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    \(g[r_, \[Theta]_, \[Phi]_] := {r\ Cos[\[Phi]]\ Sin[\[Theta]], 
        r\ Sin[\[Phi]]\ Sin[\[Theta]], r\ Cos[\[Theta]]}\), "\n", 
    \(planotheta[\[Theta]_] := 
      Show[{Graphics3D[{Thickness[ .01], 
              Line[{{\(-7\), 0, 0}, {7, 0, 
                    0}}], \[IndentingNewLine]Line[{{0, \(-7\), 0}, {0, 7, 
                    0}}], Line[{{0, 0, \(-7\)}, {0, 0, 7}}], 
              Text["\<\[Rho]\>", {4, 0, 0}, {\(-1.25\), 1}], 
              Text["\<\[Theta]\>", {0, 7, 0}, {\(-1\), 
                  1}], \[IndentingNewLine]Text["\<\[Phi]\>", {0, 0, 
                  7}, {0, \(-1.25\)}]}], \
\[IndentingNewLine]ParametricPlot3D[{s, \[Theta], t}, {s, 0, 3.5}, {t, 0, 
              2  \[Pi]}, \[IndentingNewLine]BoxRatios \[Rule] {1, 1, 1}, 
            DisplayFunction \[Rule] Identity]}, Boxed \[Rule] False, 
        Axes -> None, \[IndentingNewLine]DisplayFunction \[Rule] 
          Identity]\), "\n", 
    \(transplanotheta[\[Theta]_] := 
      Show[{Graphics3D[{Thickness[ .01], 
              Line[{{\(-4\), 0, 0}, {4, 0, 
                    0}}], \[IndentingNewLine]Line[{{0, \(-4\), 0}, {0, 4, 
                    0}}], Line[{{0, 0, \(-4\)}, {0, 0, 4}}], 
              Text["\<x\>", {4, 0, 0}, {\(-1.25\), 1}], 
              Text["\<y\>", {0, 4, 0}, {\(-1\), 
                  1}], \[IndentingNewLine]Text["\<z\>", {0, 0, 
                  4}, {0, \(-1.25\)}]}], \[IndentingNewLine]ParametricPlot3D[
            Evaluate[g[u, \[Theta], v]], {u, 0, 3.5}, {v, 0, 
              2  \[Pi]}, \[IndentingNewLine]BoxRatios \[Rule] {1, 1, 1}, 
            DisplayFunction \[Rule] Identity]}, Boxed \[Rule] False, 
        Axes -> None, 
        PlotRange \[Rule] {{\(-4\), 4}, {\(-4\), 4}, {\(-4\), 
              4}}, \[IndentingNewLine]DisplayFunction \[Rule] 
          Identity]\), "\n", 
    \(coordenadatheta[\[Theta]_] := 
      Show[GraphicsArray[{planotheta[\[Theta]], transplanotheta[\[Theta]]}], 
        DisplayFunction \[Rule] $DisplayFunction, 
        ImageSize \[Rule] {527.25, 404.375}]\)}], "Input"],

Cell[BoxData[
    \(Do[coordenadatheta[\[Theta]], {\[Theta], 0, \[Pi], Pi/15}]\)], "Input"],

Cell[BoxData[{
    \(planophi[\[Phi]_] := 
      Show[{Graphics3D[{Thickness[ .01], 
              Line[{{\(-7\), 0, 0}, {7, 0, 
                    0}}], \[IndentingNewLine]Line[{{0, \(-7\), 0}, {0, 7, 
                    0}}], Line[{{0, 0, \(-7\)}, {0, 0, 7}}], 
              Text["\<\[Rho]\>", {4, 0, 0}, {\(-1.25\), 1}], 
              Text["\<\[Theta]\>", {0, 7, 0}, {\(-1\), 
                  1}], \[IndentingNewLine]Text["\<\[Phi]\>", {0, 0, 
                  7}, {0, \(-1.25\)}]}], \
\[IndentingNewLine]ParametricPlot3D[{w, e, \[Phi]}, {w, 0, 3.5}, {e, 
              0, \[Pi]}, \[IndentingNewLine]BoxRatios \[Rule] {1, 1, 1}, 
            DisplayFunction \[Rule] Identity]}, Boxed \[Rule] False, 
        Axes -> None, \[IndentingNewLine]DisplayFunction \[Rule] 
          Identity]\), "\n", 
    \(transplanophi[\[Phi]_] := 
      Show[{Graphics3D[{Thickness[ .01], 
              Line[{{\(-4\), 0, 0}, {4, 0, 
                    0}}], \[IndentingNewLine]Line[{{0, \(-4\), 0}, {0, 4, 
                    0}}], Line[{{0, 0, \(-4\)}, {0, 0, 4}}], 
              Text["\<x\>", {4, 0, 0}, {\(-1.25\), 1}], 
              Text["\<y\>", {0, 4, 0}, {\(-1\), 
                  1}], \[IndentingNewLine]Text["\<z\>", {0, 0, 
                  4}, {0, \(-1.25\)}]}], \[IndentingNewLine]ParametricPlot3D[
            Evaluate[g[\[Rho], th, \[Phi]]], {\[Rho], 0, 3.5}, {th, 
              0, \[Pi]}, \[IndentingNewLine]BoxRatios \[Rule] {1, 1, 1}, 
            DisplayFunction \[Rule] Identity]}, Boxed \[Rule] False, 
        Axes -> None, 
        PlotRange \[Rule] {{\(-4\), 4}, {\(-4\), 4}, {\(-4\), 
              4}}, \[IndentingNewLine]DisplayFunction \[Rule] 
          Identity]\), "\n", 
    \(coordenadaphi[\[Phi]_] := 
      Show[GraphicsArray[{planophi[\[Phi]], transplanophi[\[Phi]]}], 
        DisplayFunction \[Rule] $DisplayFunction, 
        ImageSize \[Rule] {527.25, 404.375}]\)}], "Input"],

Cell[BoxData[
    \(Do[coordenadaphi[\[Phi]], {\[Phi], 0, 2  \[Pi], Pi/15}]\)], "Input"],

Cell[BoxData[{
    \(planorho[r_] := 
      Show[{Graphics3D[{Thickness[ .01], 
              Line[{{\(-7\), 0, 0}, {7, 0, 
                    0}}], \[IndentingNewLine]Line[{{0, \(-7\), 0}, {0, 7, 
                    0}}], Line[{{0, 0, \(-7\)}, {0, 0, 7}}], 
              Text["\<\[Rho]\>", {4, 0, 0}, {\(-1.25\), 1}], 
              Text["\<\[Theta]\>", {0, 7, 0}, {\(-1\), 
                  1}], \[IndentingNewLine]Text["\<\[Phi]\>", {0, 0, 
                  7}, {0, \(-1.25\)}]}], \
\[IndentingNewLine]ParametricPlot3D[{r, ze, ph}, {ze, 0, \[Pi]}, {ph, 0, 
              2  \[Pi]}, \[IndentingNewLine]BoxRatios \[Rule] {1, 1, 1}, 
            DisplayFunction \[Rule] Identity]}, Boxed \[Rule] False, 
        Axes -> None, \[IndentingNewLine]DisplayFunction \[Rule] 
          Identity]\), "\n", 
    \(transplanorho[r_] := 
      Show[{Graphics3D[{Thickness[ .01], 
              Line[{{\(-4\), 0, 0}, {4, 0, 
                    0}}], \[IndentingNewLine]Line[{{0, \(-4\), 0}, {0, 4, 
                    0}}], Line[{{0, 0, \(-4\)}, {0, 0, 4}}], 
              Text["\<x\>", {4, 0, 0}, {\(-1.25\), 1}], 
              Text["\<y\>", {0, 4, 0}, {\(-1\), 
                  1}], \[IndentingNewLine]Text["\<z\>", {0, 0, 
                  4}, {0, \(-1.25\)}]}], \[IndentingNewLine]ParametricPlot3D[
            Evaluate[g[r, tz, fi]], {tz, 0, \[Pi]}, {fi, 0, 
              2  \[Pi]}, \[IndentingNewLine]BoxRatios \[Rule] {1, 1, 1}, 
            DisplayFunction \[Rule] Identity]}, Boxed \[Rule] False, 
        Axes -> None, 
        PlotRange \[Rule] {{\(-4\), 4}, {\(-4\), 4}, {\(-4\), 
              4}}, \[IndentingNewLine]DisplayFunction \[Rule] 
          Identity]\), "\n", 
    \(coordenadarho[r_] := 
      Show[GraphicsArray[{planorho[r], transplanorho[r]}], 
        DisplayFunction \[Rule] $DisplayFunction, 
        ImageSize \[Rule] {527.25, 404.375}]\)}], "Input"],

Cell[BoxData[
    \(Do[coordenadarho[r], {r,  .5, 3.5, 3.5/15}]\)], "Input"],

Cell[BoxData[
    \(Do[Show[{transplanorho[r], 
          Graphics3D[{Hue[0], PointSize[ .02], Point[g[2, \[Pi]/3, 0]]}]}, 
        Boxed \[Rule] False, Axes -> None, 
        PlotRange \[Rule] {{\(-4\), 4}, {\(-4\), 4}, {\(-4\), 4}}, 
        ImageSize \[Rule] {527.25, 
            404.375}, \[IndentingNewLine]DisplayFunction \[Rule] \
$DisplayFunction], {r, 0, 2,  .25}]\)], "Input"],

Cell[BoxData[
    \(Do[Show[{transplanotheta[\[Theta]], 
          Graphics3D[{Hue[0], PointSize[ .02], Point[g[2, \[Pi]/3, 0]]}]}, 
        Boxed \[Rule] False, Axes -> None, 
        PlotRange \[Rule] {{\(-4\), 4}, {\(-4\), 4}, {\(-4\), 4}}, 
        ImageSize \[Rule] {527.25, 
            404.375}, \[IndentingNewLine]DisplayFunction \[Rule] \
$DisplayFunction], {\[Theta], \[Pi]/3 -  .7, \[Pi]/3,  .1}]\)], "Input"],

Cell[BoxData[
    \(Do[Show[{transplanophi[\(-\[Phi]\)], 
          Graphics3D[{Hue[0], PointSize[ .02], Point[g[2, \[Pi]/3, 0]]}]}, 
        Boxed \[Rule] False, Axes -> None, 
        PlotRange \[Rule] {{\(-4\), 4}, {\(-4\), 4}, {\(-4\), 4}}, 
        ImageSize \[Rule] {527.25, 
            404.375}, \[IndentingNewLine]DisplayFunction \[Rule] \
$DisplayFunction], {\[Phi], \(-\[Pi]\)/2, 0, \[Pi]/10}]\)], "Input"],

Cell[BoxData[
    \(Do[Show[{transplanerho[2], transplanetheta[\[Pi]/3], 
          transplanephi[\(-\[Phi]\)], 
          Graphics3D[{Hue[0], PointSize[ .03], Point[g[2, \[Pi]/3, 0]]}]}, 
        Boxed \[Rule] False, Axes -> None, 
        PlotRange \[Rule] {{\(-4\), 4}, {\(-4\), 4}, {\(-4\), 4}}, 
        ImageSize \[Rule] {527.25, 
            404.375}, \[IndentingNewLine]DisplayFunction \[Rule] \
$DisplayFunction], {\[Phi], \(-\[Pi]\)/2, 0, \[Pi]/10}]\)], "Input"],

Cell[BoxData[
    \(planoscoordenados[r_, \[Theta]_, \[Phi]_] := 
      Show[{transplanorho[r], transplanotheta[\[Theta]], 
          transplanophi[\(-\[Phi]\)], 
          Graphics3D[{Hue[0], PointSize[ .03], Point[g[2, \[Pi]/3, 0]]}]}, 
        Boxed \[Rule] False, Axes -> None, 
        PlotRange \[Rule] {{\(-4\), 4}, {\(-4\), 4}, {\(-4\), 4}}, 
        ImageSize \[Rule] {527.25, 404.375}]\)], "Input"],

Cell[BoxData[
    \(\(Show[planoscoordenados[2, \[Pi]/3, 0], 
        DisplayFunction \[Rule] $DisplayFunction];\)\)], "Input"],

Cell[BoxData[{
    \(fg[1] = planoscoordenados[1, \[Pi]/3 -  .9, \(-\[Pi]\)/2. ]; 
    fg[2] = planoscoordenados[
        1, \[Pi]/3 -  .625, \(-\[Pi]\)/2. ];\), "\[IndentingNewLine]", 
    \(\(fg[3] = 
        planoscoordenados[1, \[Pi]/3 -  .4, \(-\[Pi]\)/2. ];\)\), "\n", 
    \(\(fg[4] = 
        planoscoordenados[
          1, \[Pi]/3 -  .125, \(-\[Pi]\)/2. ];\)\), "\[IndentingNewLine]", 
    \(\(fg[5] = 
        planoscoordenados[
          1, \[Pi]/3. , \(-\[Pi]\)/2. ];\)\), "\[IndentingNewLine]", 
    \(\(fg[6] = 
        planoscoordenados[
          1, \[Pi]/3. , \(-3\) \[Pi]/8. ];\)\), "\[IndentingNewLine]", 
    \(\(fg[7] = 
        planoscoordenados[
          1, \[Pi]/3. , \(-\[Pi]\)/4. ];\)\), "\[IndentingNewLine]", 
    \(\(fg[8] = 
        planoscoordenados[
          1, \[Pi]/3. , \(-\[Pi]\)/8. ];\)\), "\[IndentingNewLine]", 
    \(\(fg[9] = 
        planoscoordenados[1, \[Pi]/3. , 0. ];\)\), "\[IndentingNewLine]", 
    \(\(fg[10] = 
        planoscoordenados[1.25, \[Pi]/3. , 0. ];\)\), "\[IndentingNewLine]", 
    \(fg[11] = planoscoordenados[1.5, \[Pi]/3. , 0. ]; 
    fg[12] = planoscoordenados[1.75, \[Pi]/3. , 
        0. ];\), "\[IndentingNewLine]", 
    \(\(fg[13] = planoscoordenados[2, \[Pi]/3. , 0. ];\)\)}], "Input"],

Cell[BoxData[
    \(\(esfericasmovie := 
        Table[Show[fg[k], DisplayFunction \[Rule] $DisplayFunction], {k, 1, 
            13}];\)\)], "Input"],

Cell[BoxData[
    \(\(esfericasmovie;\)\)], "Input"],

Cell[BoxData[{
    \(\(g[r_, \[Theta]_, \[Phi]_] := {r\ Cos[\[Phi]]\ Sin[\[Theta]], 
          r\ Sin[\[Phi]]\ Sin[\[Theta]], 
          r\ Cos[\[Theta]]};\)\), "\[IndentingNewLine]", 
    \(\(planoscoordenados[
          r_, \[Theta]_, \[Phi]_] := {ParametricPlot3D[
            Evaluate[g[r, tz, fi]], {tz, 0, \[Pi]}, {fi, 0, 
              2  \[Pi]}, \[IndentingNewLine]BoxRatios \[Rule] {1, 1, 1}, 
            DisplayFunction \[Rule] Identity], 
          ParametricPlot3D[
            Evaluate[g[u, \[Theta], v]], {u, 0, 3.5}, {v, 0, 
              2  \[Pi]}, \[IndentingNewLine]BoxRatios \[Rule] {1, 1, 1}, 
            DisplayFunction \[Rule] Identity], 
          ParametricPlot3D[
            Evaluate[g[\[Rho], th, \(-\[Phi]\)]], {\[Rho], 0, 3.5}, {th, 
              0, \[Pi]}, \[IndentingNewLine]BoxRatios \[Rule] {1, 1, 1}, 
            DisplayFunction \[Rule] Identity]};\)\), "\[IndentingNewLine]", 
    \(fg[1] = planoscoordenados[1, \[Pi]/3 -  .9, \(-\[Pi]\)/2. ]; 
    fg[2] = planoscoordenados[1, \[Pi]/3 -  .625, \(-\[Pi]\)/2. ];\), "\n", 
    \(\(fg[3] = 
        planoscoordenados[1, \[Pi]/3 -  .4, \(-\[Pi]\)/2. ];\)\), "\n", 
    \(\(fg[4] = 
        planoscoordenados[1, \[Pi]/3 -  .125, \(-\[Pi]\)/2. ];\)\), "\n", 
    \(\(fg[5] = planoscoordenados[1, \[Pi]/3. , \(-\[Pi]\)/2. ];\)\), "\n", 
    \(\(fg[6] = 
        planoscoordenados[1, \[Pi]/3. , \(-3\) \[Pi]/8. ];\)\), "\n", 
    \(\(fg[7] = planoscoordenados[1, \[Pi]/3. , \(-\[Pi]\)/4. ];\)\), "\n", 
    \(\(fg[8] = planoscoordenados[1, \[Pi]/3. , \(-\[Pi]\)/8. ];\)\), "\n", 
    \(\(fg[9] = planoscoordenados[1, \[Pi]/3. , 0. ];\)\), "\n", 
    \(\(fg[10] = planoscoordenados[1.25, \[Pi]/3. , 0. ];\)\), "\n", 
    \(fg[11] = planoscoordenados[1.5, \[Pi]/3. , 0. ]; 
    fg[12] = planoscoordenados[1.75, \[Pi]/3. , 0. ];\), "\n", 
    \(\(fg[13] = planoscoordenados[2, \[Pi]/3. , 0. ];\)\), "\n", 
    \(\(esfericasmovie := 
        Table[Show[{Graphics3D[{Thickness[ .01], 
                  Line[{{\(-4\), 0, 0}, {4, 0, 
                        0}}], \[IndentingNewLine]Line[{{0, \(-4\), 0}, {0, 4, 
                        0}}], Line[{{0, 0, \(-4\)}, {0, 0, 4}}], 
                  Text["\<x\>", {4, 0, 0}, {\(-1.25\), 1}], 
                  Text["\<y\>", {0, 4, 0}, {\(-1\), 
                      1}], \[IndentingNewLine]Text["\<z\>", {0, 0, 
                      4}, {0, \(-1.25\)}]}], 
              Graphics3D[{Hue[0], PointSize[ .03], Point[g[2, \[Pi]/3, 0]]}], 
              fg[k]}, Boxed \[Rule] False, Axes -> None, 
            PlotRange \[Rule] {{\(-4\), 4}, {\(-4\), 4}, {\(-4\), 4}}, 
            DisplayFunction \[Rule] $DisplayFunction, 
            ImageSize \[Rule] {527.25, 404.375}], {k, 1, 13}];\)\)}], "Input"],

Cell[BoxData[
    \(\(esfericasmovie;\)\)], "Input"]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 670}},
WindowSize->{1016, 635},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification->1.5,
StyleDefinitions -> "Classroom.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 2067, 36, 670, "Input"],
Cell[3824, 89, 91, 1, 72, "Input"],
Cell[3918, 92, 1914, 34, 618, "Input"],
Cell[5835, 128, 88, 1, 72, "Input"],
Cell[5926, 131, 1885, 34, 640, "Input"],
Cell[7814, 167, 76, 1, 72, "Input"],
Cell[7893, 170, 387, 7, 202, "Input"],
Cell[8283, 179, 420, 7, 202, "Input"],
Cell[8706, 188, 417, 7, 202, "Input"],
Cell[9126, 197, 472, 8, 176, "Input"],
Cell[9601, 207, 408, 7, 198, "Input"],
Cell[10012, 216, 127, 2, 94, "Input"],
Cell[10142, 220, 1258, 28, 406, "Input"],
Cell[11403, 250, 150, 3, 120, "Input"],
Cell[11556, 255, 52, 1, 72, "Input"],
Cell[11611, 258, 2725, 46, 878, "Input"],
Cell[14339, 306, 52, 1, 72, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

